// Shared JS: smooth scroll, active nav and contact form handler

// Smooth scrolling for internal links
document.querySelectorAll('a[href^="#"]').forEach(a=>{
  a.addEventListener('click', function(e){
    const target = document.querySelector(this.getAttribute('href'));
    if(target){
      e.preventDefault();
      target.scrollIntoView({behavior:'smooth',block:'start'});
    }
  });
});

// Active nav link by pathname or data-page
function updateActiveNav(){
  const navLinks = document.querySelectorAll('nav a');
  const page = document.body.getAttribute('data-page') || window.location.pathname.split('/').pop() || 'index.html';
  navLinks.forEach(l=>l.classList.remove('active'));
  let selector = 'nav a[href="' + (page==='index.html' ? '#home' : page.replace('.html','')) + '"]';
  // Fallback: match by href to filename
  navLinks.forEach(l=>{
    const href = l.getAttribute('href');
    if(href && (href.includes(page.replace('.html','')) || (page==='index.html' && href==='#home'))){
      l.classList.add('active');
    }
  });
}

document.addEventListener('DOMContentLoaded', ()=>{
  updateActiveNav();
});

// Contact form handler (same behaviour as original)
function handleContact(e){
  e.preventDefault();
  const name = document.getElementById('name').value.trim();
  const email = document.getElementById('email').value.trim();
  const message = document.getElementById('message').value.trim();
  const msgEl = document.getElementById('form-msg');

  if(!name || !email || !message){
    msgEl.style.color = '#b91c1c';
    msgEl.textContent = 'Vul alstublieft alle velden in.';
    return false;
  }
  if(!/^\S+@\S+\.\S+$/.test(email)){
    msgEl.style.color = '#b91c1c';
    msgEl.textContent = 'Voer een geldig e-mailadres in.';
    return false;
  }
  msgEl.style.color = '#065f46';
  msgEl.textContent = 'Bedankt! Je bericht is klaar voor verzending (demo).';
  document.getElementById('contact-form').reset();
  return false;
}

// Expose handler globally (used by inline onsubmit attribute)
window.handleContact = handleContact;

// Toggle visibility for details blocks (used by project cards)
function toggleDetails(id){
  const el = document.getElementById(id);
  if(!el) return;
  const isOpen = el.classList.contains('open');
  if(isOpen){
    // Close: set explicit maxHeight then animate to 0
    el.style.maxHeight = el.scrollHeight + 'px';
    // force reflow
    // eslint-disable-next-line no-unused-expressions
    el.offsetHeight;
    el.style.transition = 'max-height 350ms ease, opacity 200ms ease';
    el.style.maxHeight = '0';
    el.classList.remove('open');
    el.setAttribute('aria-hidden','true');
    // clear inline maxHeight after animation
    setTimeout(()=>{
      el.style.transition = '';
      el.style.maxHeight = '';
    }, 380);
  } else {
    // Open: measure and animate to scrollHeight
    el.classList.add('open');
    el.setAttribute('aria-hidden','false');
    el.style.transition = 'max-height 350ms ease, opacity 200ms ease';
    const height = el.scrollHeight + 'px';
    el.style.maxHeight = height;
    // remove maxHeight after animation to allow responsive height
    setTimeout(()=>{
      el.style.transition = '';
      el.style.maxHeight = '';
    }, 380);
  }
}

window.toggleDetails = toggleDetails;